// GpPenEscY.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscY Dialog


CGpPenEscY::CGpPenEscY(CWnd* pParent /*=NULL*/)
	: CIndecatePolygon(CGpPenEscY::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEscY)
	m_cLineStyle = 0;
	//}}AFX_DATA_INIT

	m_iActionCount = 0 ;
	m_bAction = FALSE ;
	m_bAdd = FALSE ;
	m_bMoving = FALSE ;

	Create(IDD,pParent);
}


void CGpPenEscY::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEscY)
	DDX_CBIndex(pDX, IDC_cLineStyle, m_cLineStyle);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpPenEscY, CDialog)
	//{{AFX_MSG_MAP(CGpPenEscY)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscY Message Handler

void CGpPenEscY::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}

// Create Content
CContents*  CGpPenEscY::CreateContents()
{
	// Create empty content
	CContentsEscY* pContents = new CContentsEscY();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	// Line Style
	pContents->m_Data.cLineStyle = m_cLineStyle ;
	if( pContents->m_Data.cLineStyle > 3 )
	{
		pContents->m_Data.cLineStyle += 4 ;
	}

	// Set Content the display position
	pContents->m_Data.iCount = m_iActionCount ;
	memcpy( pContents->m_Data.iX, m_iX, sizeof(m_iX) ) ;
	memcpy( pContents->m_Data.iY, m_iY, sizeof(m_iY) ) ;
	return( pContents );
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Draw Polygon
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Erase drawing
void CIndecatePolygon::ActionErase(CDC* pDC)
{
	if( m_iActionCount == 2 )
	{
		InvertLine(pDC,m_iX[0],m_iY[0],m_iX[1],m_iY[1]);
	}
	else if( m_iActionCount >= 2 )
	{
		for( int i = 0; i < m_iActionCount; i++ )
		{
			InvertLine(pDC,m_iX[i],m_iY[i],m_iX[(i+1)%m_iActionCount],m_iY[(i+1)%m_iActionCount]);
		}
	}
	m_bAction = FALSE ;
}

// Draw to the new position
void CIndecatePolygon::ActionDisplay(CPoint NewPoint,CDC* pDC)
{
	// Erase
	ActionErase(pDC);

	if( m_bAdd )
	{
		// Draw at new position
		if( !m_bMoving )
		{
			m_iActionCount++ ;
		}
		m_iX[m_iActionCount-1] = NewPoint.x ;
		m_iY[m_iActionCount-1] = NewPoint.y ;
	}
	if( m_iActionCount == 2 )
	{
		InvertLine(pDC,m_iX[0],m_iY[0],m_iX[1],m_iY[1]);
	}
	else if( m_iActionCount >= 2 )
	{
		for( int i = 0; i < m_iActionCount; i++ )
		{
			InvertLine(pDC,m_iX[i],m_iY[i],m_iX[(i+1)%m_iActionCount],m_iY[(i+1)%m_iActionCount]);
		}
	}
	m_bAction = TRUE ;
}


// Start Drawing
int  CIndecatePolygon::ActionDown(UINT nFlags, CPoint point,CDC* pDC)
{
	if( !m_bAction )
	{
		m_iActionCount = 0 ;
		m_bMoving = FALSE ;
	}
	if( m_bMoving || (DEF_MAX_POLY_NODE > m_iActionCount) )
	{
		m_bAdd = TRUE ;
		// Draw
		ActionDisplay(point,pDC) ;
		m_bAdd = FALSE ;
	}
	m_bMoving = FALSE ;

	return( B_ActionContinue );	// Continue
}


// Move
int  CIndecatePolygon::ActionMove(UINT nFlags, CPoint point,CDC* pDC)
{
	if( !m_bAction )
	{
		return (B_ActionStop) ;
	}

	if( m_bMoving || (DEF_MAX_POLY_NODE > m_iActionCount) )
	{
		// Erase
		ActionErase(pDC);
		m_bAction = TRUE ;

		if( !m_bMoving )
		{
			m_iActionCount++ ;
		}
		m_bMoving = TRUE ;
		m_iX[m_iActionCount-1] = point.x ;
		m_iY[m_iActionCount-1] = point.y ;

		if( m_iActionCount == 2 )
		{
			InvertLine(pDC,m_iX[0],m_iY[0],m_iX[1],m_iY[1]);
		}
		else if( m_iActionCount >= 2 )
		{
			for( int i = 0; i < m_iActionCount; i++ )
			{
				InvertLine(pDC,m_iX[i],m_iY[i],m_iX[(i+1)%m_iActionCount],m_iY[(i+1)%m_iActionCount]);
			}
		}	
	}
	else
	{
		ActionDisplay(point,pDC) ;
	}

	return( B_ActionContinue );	// Continue
}

// End
int  CIndecatePolygon::ActionUp(UINT nFlags, CPoint point,CDC* pDC)
{
	return( B_ActionContinue );
}

// Cancel
int  CIndecatePolygon::ActionCancel(CDC* pDC)
{
	ActionErase(pDC) ;

	return( B_ActionStop );
}

bool CIndecatePolygon::UseRButton(void)
{
	return ((m_bAction && (m_iActionCount>=3)) ? true : false) ;
}


int CIndecatePolygon::ActionRDown(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	ActionErase(pDC) ;
	m_bMoving = FALSE ;

	return( B_ActionOk );
}

